#include <reg52.H>
#include <intrins.h>
#include <string.h>
#include <stdio.h>
//======================================================
//ƬѡźCS ֱӽӵ

sbit lcd_sclk =P2^1;  	//ӿڶ:lcd_sclkLCDSCLK   //SCLKӵD0
sbit lcd_sda  =P2^2;   	//ӿڶ:lcd_sdaLCDSDA	 //SDINӵD1
sbit lcd_reset=P2^3;   	//ӿڶ:lcd_resetLCDRESET
sbit lcd_dc   =P1^0;    //ӿڶ:lcd_dcLCDD/C

sbit key=P3^2;			    //һP3.0GND֮һ


#define uchar unsigned char 
#define uint unsigned int
#define ulong unsigned long


#include <ASCII_CODE_8X16_5X8_VERTICAL.H>
#include <Chinese_And_Graphic.H>

//ʱ
void delay(int i)               
{
	int j,k;
	for(j=0;j<i;j++)
		for(k=0;k<110;k++);
}


//ȴP2.0GND֮һ
void waitkey()
{
repeat:	if(key==1)	goto repeat;
		else	delay(1000);			
}

//дָOLEDʾģ
void transfer_command(int data1)   
{
    uchar i;
    lcd_dc= 0;    
	for(i=0;i<8;i++)
	{
        lcd_sclk = 0;    
        if (data1 & 0x80)	lcd_sda = 1;
        else  				lcd_sda = 0;
        lcd_sclk = 1; 
        data1 <<= 1;    
    }
}

//дݵOLEDʾģ
void transfer_data(int data1)
{
    uchar i;
    lcd_dc= 1;    
	for(i=0;i<8;i++)
	{
        lcd_sclk = 0;    
        if (data1 & 0x80)	lcd_sda = 1;
        else  				lcd_sda = 0;
        lcd_sclk = 1; 
        data1 <<= 1;    
    }
}


//OLEDʾģʼ
void initial_lcd()
{
  	lcd_reset=0;        	//͵ƽλ
  	delay(500);
  	lcd_reset=1;		   	//λ
  	delay(200); 
	       
	transfer_command(0xae);	//ʾ

	transfer_command(0xd5);	//Ƶ
	transfer_command(0x80);

	transfer_command(0xa8);	//duty
	transfer_command(0x3f);	//duty=1/64

	transfer_command(0xd3);	//ʾƫ
	transfer_command(0x00);	

	transfer_command(0x40);	//ʼ

	transfer_command(0x8d);	//ѹ
	transfer_command(0x14);	

	transfer_command(0x20);	//page address mode
	transfer_command(0x02);

	transfer_command(0xc8); //ɨ˳򣺴ϵ	//c1
	transfer_command(0xa1); //ɨ˳򣺴	//a0

	transfer_command(0xda); //sequential configuration
	transfer_command(0x12);




	transfer_command(0x81); //΢Աȶ,ָ0x81ҪĶֵ
	transfer_command(0xcf); //΢Աȶȵֵ÷Χ0x000xff


	transfer_command(0xd9); //Set Pre-Charge Period
	transfer_command(0xf1);

	transfer_command(0xdb); //Set VCOMH Deselect Level
	transfer_command(0x40);

	transfer_command(0xaf); //ʾ
}


void lcd_address(uchar page,uchar column)
{
	column=column-1;  							//ƽ˵ĵ1УLCDICǵ0Сȥ1.
	page=page-1;
	transfer_command(0xb0+page);   			//ҳַÿҳ8Сһ64бֳ8ҳƽ˵ĵ1ҳLCDICǵ0ҳȥ1
	transfer_command(((column>>4)&0x0f)+0x10);	//еַĸ4λ
	transfer_command(column&0x0f);				//еַĵ4λ
}

//ȫ
void clear_screen()
{
	unsigned char i,j;
 	for(j=0;j<8;j++)
	{
		lcd_address(1+j,1);
		for(i=0;i<128;i++)
		{
			transfer_data(0x00);
		}
	}
}



//full display test
void full_display(uchar data1,uchar data2)
{
	int i,j;
	for(i=0;i<8;i++)
	{
		lcd_address(i+1,1);
		for(j=0;j<64;j++)
		{
			transfer_data(data1);
			transfer_data(data2);    			    
		}
	}          
}
//ʾ128x64ͼ
void display_128x64(uchar *dp)
{
	uint i,j;
	for(j=0;j<8;j++)
	{
		lcd_address(j+1,1);
		for (i=0;i<128;i++)
		{	
			transfer_data(*dp);					//дݵLCD,ÿдһ8λݺеַԶ1
			dp++;
		}
	}
}

//ʾ128x16ͼ
void display_128x16(uchar page,uchar column,uchar *dp)
{
	uint i,j;
	for(j=0;j<2;j++)
	{
		lcd_address(page+j,column);
		for (i=0;i<128;i++)
		{	
			transfer_data(*dp);					//дݵLCD,ÿдһ8λݺеַԶ1
			dp++;
		}
	}
}

//ʾ32x32ͼ񡢺֡Ƨֻ32x32ͼ
void display_graphic_32x32(uchar page,uchar column,uchar *dp)
{
	uchar i,j;
	for(j=0;j<4;j++)
	{
		lcd_address(page+j,column);
		for (i=0;i<32;i++)
		{	
			transfer_data(*dp);		//дݵLCD,ÿдһ8λݺеַԶ1
			dp++;
		}
	}
}

//ʾ16x16ͼ񡢺֡Ƨֻ16x16ͼ
void display_graphic_16x16(uchar page,uchar column,uchar *dp)
{
	uchar i,j;
	for(j=0;j<2;j++)
	{
		lcd_address(page+j,column);
		for (i=0;i<16;i++)
		{	
			transfer_data(*dp);		//дݵLCD,ÿдһ8λݺеַԶ1
			dp++;
		}
	}
}

//ʾ8x16ͼASCII, 8x16ַͼ
void display_graphic_8x16(uchar page,uchar column,uchar *dp)
{
	uchar i,j;
	for(j=0;j<2;j++)
	{
		lcd_address(page+j,column);
		for (i=0;i<8;i++)
		{	
			transfer_data(*dp);					//дݵLCD,ÿдһ8λݺеַԶ1
			dp++;
		}
	}
}

//ʾ8x16ĵַĲֱΪҳ,Уַָ룩
void display_string_8x16(uint page,uint column,uchar *text)
{
	uint i=0,j,k,n;
	if(column>123)
	{
		column=1;
		page+=2;
	}
	while(text[i]>0x00)
	{	
		if((text[i]>=0x20)&&(text[i]<=0x7e))
		{
			j=text[i]-0x20;
			for(n=0;n<2;n++)
			{			
				lcd_address(page+n,column);
				for(k=0;k<8;k++)
				{					
					transfer_data(ascii_table_8x16[j][k+8*n]);	//дݵLCD,ÿд1ֽڵݺеַԶ1
				}
			}
			i++;
			column+=8;
		}
		else
		i++;
	}
}



//ʾ5x8ĵַĲֱΪҳ,Уַָ룩
void display_string_5x8(uint page,uint column,uchar reverse,uchar *text)
{
	uint i=0,j,k,disp_data;
	while(text[i]>0x00)
	{	
		if((text[i]>=0x20)&&(text[i]<=0x7e))
		{
			j=text[i]-0x20;
			lcd_address(page,column);
			for(k=0;k<5;k++)
			{
				if(reverse==1)
				{
					disp_data=~ascii_table_5x8[j][k];
				}
				else
				{
					disp_data=ascii_table_5x8[j][k];
				}
				
				transfer_data(disp_data);	//дݵLCD,ÿд1ֽڵݺеַԶ1
			}
			if(reverse==1)	transfer_data(0xff);	//дһпհУʹ5x8ַַ֮һм
			else	transfer_data(0x00);			//дһпհУʹ5x8ַַ֮һм
			i++;
			column+=6;
			if(column>123)
			{
				column=1;
				page++;
			}
		}
		else
		i++;
	}
}


//дһ16x16ĺַַ躬д֣
//Ĳ(ҳУַ
void display_string_16x16(uchar page,uchar column,uchar *text)
{
    uchar i,j,k;
    uint address; 
    
    j = 0;
    while(text[j] != '\0')
    {
        i = 0;
        address = 1;
        while(Chinese_text_16x16[i] > 0x7e)	  // >0x7f˵ASCIIַ
        {
            if(Chinese_text_16x16[i] == text[j])
            {
                if(Chinese_text_16x16[i + 1] == text[j + 1])
                {
                    address = i * 16;
                    break;
                }
            }
            i += 2;            
        }
        
        if(column > 113)
        {
            column = 0;
            page += 2;
        }
        
        if(address != 1)// ʾ                   
        {
            
			for(k=0;k<2;k++)
			{
				lcd_address(page+k,column);
	            for(i = 0; i < 16; i++)               
	            {
	                transfer_data(Chinese_code_16x16[address]);   
	                address++;
	            }
   			}
            j += 2;        
        }
        else              //ʾհַ            
        {
			for(k=0;k<2;k++)
			{
				lcd_address(page+k,column);
	            for(i = 0; i < 16; i++)               
	            {
	                transfer_data(0x00);   
	            }
   			}
            
            j++;
        }
        
        column+=16;
    }
}


//ʾ16x16ĺֻASCII8x16ַַ
//Ĳ(ҳУַ
void disp_string_8x16_16x16(uchar page,uchar column,uchar *text)
{
    uchar temp[3];
    uchar i = 0;    
    
    while(text[i] != '\0')
    {
        if(text[i] > 0x7e)
        {
            temp[0] = text[i];
            temp[1] = text[i + 1];
            temp[2] = '\0';          //Ϊֽ
            display_string_16x16(page,column,temp);  //ʾ
            column += 16;
            i += 2;
        }
        else
        {
            temp[0] = text[i];    
            temp[1] = '\0';          //ĸռһֽ
            display_string_8x16(page, column, temp);  //ʾĸ
            column += 8;
            i++;
        }
    }
}

void main(void)
{ 
    initial_lcd();							//ʼ
		clear_screen();							//
	while(1)
	{
    //ȫʾ
    full_display(0xff,0xff);
    delay(3000);
    clear_screen(); 

    //ʾ32x32ĺ֣16x16ĺ
		disp_string_8x16_16x16(1,1,"0.96OLEDҺģ");	  //ʾַĲֱΪPAGE,,ַָ룩
		disp_string_8x16_16x16(3,1,"Ϊרҵ");		//ʾ16x16ִ8x16ַĲֱΪҳ,,ַָ룩
		display_graphic_32x32 (5,17+32*0,xin); 					//ʾ32x32ĺ֣ĲֱΪPAGE,,ַָ룩
		display_graphic_32x32 (5,17+32*1,tai);
		display_graphic_32x32 (5,17+32*2,wei); 			 			
		waitkey();
    delay(100);

    //5*8ַʾЧ
		clear_screen();    									//clear all dots			
		display_string_5x8(1,1,1,"        MENU         ");	//ʾ5x8ַĲֱΪҳУǷԣָ룩
		display_string_5x8(3,1,0,"Select>>>>");
		display_string_5x8(3,64,1,"1.Graphic ");	    
		display_string_5x8(4,64,0,"2.Chinese " );
		display_string_5x8(5,64,0,"3.Movie   ");
		display_string_5x8(6,64,0,"4.Contrast");
		display_string_5x8(7,64,0,"5.Mirror  ");
		display_string_5x8(8,1,1,"PRE  USER   DEL   NEW");
		display_string_5x8(8,19,0," ");
		display_string_5x8(8,65,0," ");
		display_string_5x8(8,97,0," ");
		waitkey();
    delay(100);
    clear_screen();
	}
}



